﻿var exportedFilesBrowser = {
    context: $(".v-exportedFilesBrowser"),
    datatable: null,
    initialize: function () {
        var taskId = $("#TaskId", exportedFilesBrowser.context).val();

        if (typeof taskId !== "undefined" && taskId.length > 0)
            exportedFilesBrowser.initializeDataTable(taskId);
    },
    initializeDataTable: function (taskId) {
        this.datatable = $(".h-exportedFilesTable", exportedFilesBrowser.context).a4datatable({
            displayColumnSelector: true,
            displaySearchBox: false,
            allowRowSelection: true,
            ajaxAction: a4.getProjectAction("GetExportedFiles", "Extraction"),
            ajaxParams: { "taskId": taskId },
            stateKey: "exportedFilesBrowser",
            columns: [
                { "Name": "Name", "Title": resources.Name, "Data": "Name" },
                { "Name": "FileExtention", "Title": resources.Type, "Data": "FileExtention" },
                { "Name": "Size", "Title": resources.FileSize, "Data": "Size", "Type": "numeric" },
                { "Name": "Modified", "Title": resources.ModifiedOn, "Data": "Modified", "Type": "date" }
            ],
            toolBarItems: [
                { "Action": "downloadArchive", "Label": resources.DownloadArchive }
            ],
            contextMenuItems: [
                { "Action": "download", "Label": resources.DownloadFile },
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                if (action == "download")
                    exportedFilesBrowser.getFileData(row.Name);
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var names = _.pluck(rows, "Name");

                if (action == "downloadArchive")
                    exportedFilesBrowser.getFilesDataArchive(names);
            }
        });
    },
    getFileData: function (fileName) {
        window.location = a4.getProjectAction("GetFileData", "Extraction",
        {
            fileName: fileName,
            taskId: $("#TaskId", exportedFilesBrowser.context).val()
        });
    },
    getFilesDataArchive: function (fileNames) {
        window.location = a4.getProjectAction("GetFilesDataArchive", "Extraction",
        {
            fileNamesJson: JSON.stringify(fileNames),
            taskTitle: $("#TaskTitle", exportedFilesBrowser.context).val(),
            taskId: $("#TaskId", exportedFilesBrowser.context).val()
        });
    },
}

$(document).ready(function () {
    if (exportedFilesBrowser.context.length > 0) {
        exportedFilesBrowser.initialize();
    }
});